/*
 * Decompiled with CFR 0.152.
 */
package com.zeroc.IceGridGUI.LiveDeployment;

import com.jgoodies.forms.builder.ButtonBarBuilder;
import com.jgoodies.forms.builder.DefaultFormBuilder;
import com.jgoodies.forms.factories.Borders;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import com.jgoodies.forms.util.LayoutStyle;
import com.zeroc.IceGridGUI.LiveDeployment.Root;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;

class ObjectDialog
extends JDialog {
    private JTextArea _proxy = new JTextArea(3, 40);
    private JTextField _type = new JTextField(40);
    private JComboBox _typeCombo = new JComboBox<Object>(new Object[]{QUERY_OBJECT});
    private JFrame _mainFrame;
    private static final Object QUERY_OBJECT = new Object(){

        public String toString() {
            return "Query object to retrieve type";
        }
    };

    ObjectDialog(final Root root, boolean readOnly) {
        super(root.getCoordinator().getMainFrame(), (readOnly ? "" : "New ") + "Dynamic Well-Known Object - IceGrid GUI", true);
        this.setDefaultCloseOperation(1);
        this._mainFrame = root.getCoordinator().getMainFrame();
        this._proxy.setLineWrap(true);
        if (readOnly) {
            this._proxy.setEditable(false);
            this._proxy.setOpaque(false);
            this._type.setEditable(false);
        } else {
            this._typeCombo.setEditable(true);
        }
        FormLayout layout = new FormLayout("right:pref, 3dlu, pref", "");
        DefaultFormBuilder builder = new DefaultFormBuilder(layout);
        builder.border(Borders.DIALOG);
        builder.rowGroupingEnabled(true);
        builder.lineGapSize(LayoutStyle.getCurrent().getLinePad());
        builder.append("Proxy");
        builder.nextLine();
        builder.append("");
        builder.nextRow(-2);
        CellConstraints cc = new CellConstraints();
        JScrollPane scrollPane = new JScrollPane(this._proxy);
        builder.add((Component)scrollPane, cc.xywh(builder.getColumn(), builder.getRow(), 1, 3));
        builder.nextRow(2);
        builder.nextLine();
        if (readOnly) {
            builder.append("Type", (Component)this._type);
        } else {
            builder.append("Type", (Component)this._typeCombo);
        }
        builder.nextLine();
        Container contentPane = this.getContentPane();
        if (readOnly) {
            contentPane.add(builder.getPanel());
        } else {
            JButton okButton = new JButton("OK");
            ActionListener okListener = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (ObjectDialog.this._proxy.isEditable()) {
                        String type = null;
                        if (ObjectDialog.this._typeCombo.getSelectedItem() != QUERY_OBJECT) {
                            type = ObjectDialog.this._typeCombo.getSelectedItem().toString();
                        }
                        root.addObject(ObjectDialog.this._proxy.getText(), type, ObjectDialog.this);
                    } else {
                        ObjectDialog.this.setVisible(false);
                    }
                }
            };
            okButton.addActionListener(okListener);
            this.getRootPane().setDefaultButton(okButton);
            JButton cancelButton = new JButton("Cancel");
            ActionListener cancelListener = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ObjectDialog.this.setVisible(false);
                }
            };
            cancelButton.addActionListener(cancelListener);
            JPanel buttonBar = new ButtonBarBuilder().addGlue().addButton(okButton, cancelButton).build();
            buttonBar.setBorder(Borders.DIALOG);
            contentPane.setLayout(new BoxLayout(contentPane, 1));
            contentPane.add(builder.getPanel());
            contentPane.add(buttonBar);
        }
        this.pack();
        this.setResizable(false);
    }

    void showDialog() {
        assert (this._proxy.isEditable());
        this._proxy.setText("");
        this._typeCombo.setSelectedItem(QUERY_OBJECT);
        this.setLocationRelativeTo(this._mainFrame);
        this.setVisible(true);
    }

    void showDialog(String proxy, String type) {
        assert (!this._proxy.isEditable());
        this._proxy.setText(proxy);
        this._type.setText(type);
        this.setLocationRelativeTo(this._mainFrame);
        this.setVisible(true);
    }
}

