﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/supplychain/SupplyChain_EXPORTS.h>
#include <aws/supplychain/model/DataLakeDataset.h>

#include <utility>

namespace Aws {
template <typename RESULT_TYPE>
class AmazonWebServiceResult;

namespace Utils {
namespace Json {
class JsonValue;
}  // namespace Json
}  // namespace Utils
namespace SupplyChain {
namespace Model {
/**
 * <p>The response parameters of UpdateDataLakeDataset.</p><p><h3>See Also:</h3>
 * <a
 * href="http://docs.aws.amazon.com/goto/WebAPI/supplychain-2024-01-01/UpdateDataLakeDatasetResponse">AWS
 * API Reference</a></p>
 */
class UpdateDataLakeDatasetResult {
 public:
  AWS_SUPPLYCHAIN_API UpdateDataLakeDatasetResult() = default;
  AWS_SUPPLYCHAIN_API UpdateDataLakeDatasetResult(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);
  AWS_SUPPLYCHAIN_API UpdateDataLakeDatasetResult& operator=(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);

  ///@{
  /**
   * <p>The updated dataset details.</p>
   */
  inline const DataLakeDataset& GetDataset() const { return m_dataset; }
  template <typename DatasetT = DataLakeDataset>
  void SetDataset(DatasetT&& value) {
    m_datasetHasBeenSet = true;
    m_dataset = std::forward<DatasetT>(value);
  }
  template <typename DatasetT = DataLakeDataset>
  UpdateDataLakeDatasetResult& WithDataset(DatasetT&& value) {
    SetDataset(std::forward<DatasetT>(value));
    return *this;
  }
  ///@}

  ///@{

  inline const Aws::String& GetRequestId() const { return m_requestId; }
  template <typename RequestIdT = Aws::String>
  void SetRequestId(RequestIdT&& value) {
    m_requestIdHasBeenSet = true;
    m_requestId = std::forward<RequestIdT>(value);
  }
  template <typename RequestIdT = Aws::String>
  UpdateDataLakeDatasetResult& WithRequestId(RequestIdT&& value) {
    SetRequestId(std::forward<RequestIdT>(value));
    return *this;
  }
  ///@}
 private:
  DataLakeDataset m_dataset;

  Aws::String m_requestId;
  bool m_datasetHasBeenSet = false;
  bool m_requestIdHasBeenSet = false;
};

}  // namespace Model
}  // namespace SupplyChain
}  // namespace Aws
