package net.minecraftforge.liquids;

import net.minecraft.nbt.NBTTagCompound;

/**
 * Implementors of this interface are a liquid which may receive a block implementation and can be placed in the world.
 *
 * @author cpw
 *
 */
@Deprecated //See new net.minecraftforge.fluids
public interface IBlockLiquid extends ILiquid {
    /**
     * Controls the type of block that is generated by this IBlockLiquid
     *
     */
    public enum BlockType {
        /**
         * No block. Completeness really.
         */
        NONE,
        /**
         * Vanilla style block, up to 8 flowing states. May be able to generate new sources.
         */
        VANILLA,
        /**
         * Finite liquid style, uses cellular automata to model flowing behaviour.
         */
        FINITE;
    }

    /**
     * Can this liquid, when placed in a specific configuration, generate new source blocks of the liquid.
     * @return if this liquid will generate new sources
     */
    public boolean willGenerateSources();

    /**
     * @return the distance this liquid will flow if placed in the world. Maximum of 7 levels for vanilla types.
     */
    public int getFlowDistance();

    /**
     * @return the RGB rendering for this liquid
     */
    public byte[] getLiquidRGB();

    /**
     * Get the texture file for rendering the liquid
     * @return the texture file for this liquid
     */
    public String getLiquidBlockTextureFile();
    /**
     * Custom properties of the liquid.
     * @return a compound tag of custom liquid properties
     */
    public NBTTagCompound getLiquidProperties();

}
